(* Ilustruje uzycie struktur przestrzeni nazw, 
   klas i klas zagniezdzonych modelu .NET *)
structure structures_demo =
struct
    (* Najpierw otworzmy przestrzen System *)
    local 
	open System 

	(* Teraz zwiazemy klase jako strukture *)
	structure M = Math

	(* Mozemy rowniez zwiazac zagniezdzona przestrzen nazw jako strukture *)
	structure D = Drawing
    in
	fun main () =
	(
		(* Statyczne pole System.Math.PI jest teraz w M *)
		print ("PI = " ^ Real.toString M.PI ^ "\n");

		(* Statyczna metoda System.Drawing.Color.get_Red jest teraz w D.Color *)
		print ("Red = " ^ valOf(D.Color.get_Red().#ToString()) ^ "\n")
	)
    end
end
